/*
 * Decompiled with CFR 0.152.
 */
package com.bezkoder.spring.login.controllers;

import com.bezkoder.spring.login.models.ERole;
import com.bezkoder.spring.login.models.Role;
import com.bezkoder.spring.login.models.User;
import com.bezkoder.spring.login.payload.request.LoginRequest;
import com.bezkoder.spring.login.payload.request.SignupRequest;
import com.bezkoder.spring.login.payload.response.MessageResponse;
import com.bezkoder.spring.login.payload.response.UserInfoResponse;
import com.bezkoder.spring.login.repository.RoleRepository;
import com.bezkoder.spring.login.repository.UserRepository;
import com.bezkoder.spring.login.security.jwt.JwtUtils;
import com.bezkoder.spring.login.security.services.UserDetailsImpl;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"}, maxAge=3600L)
@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    UserRepository userRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    PasswordEncoder encoder;
    @Autowired
    JwtUtils jwtUtils;

    @PostMapping(value={"/signin"})
    public ResponseEntity<?> authenticateUser(@Valid @RequestBody LoginRequest loginRequest) {
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)loginRequest.getUsername(), (Object)loginRequest.getPassword()));
        SecurityContextHolder.getContext().setAuthentication(authentication);
        UserDetailsImpl userDetails = (UserDetailsImpl)authentication.getPrincipal();
        ResponseCookie jwtCookie = this.jwtUtils.generateJwtCookie(userDetails);
        List roles = userDetails.getAuthorities().stream().map(item -> item.getAuthority()).collect(Collectors.toList());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Set-Cookie", new String[]{jwtCookie.toString()})).body((Object)new UserInfoResponse(userDetails.getId(), userDetails.getUsername(), userDetails.getEmail(), roles));
    }

    @PostMapping(value={"/signup"})
    public ResponseEntity<?> registerUser(@Valid @RequestBody SignupRequest signUpRequest) {
        if (this.userRepository.existsByUsername(signUpRequest.getUsername()).booleanValue()) {
            return ResponseEntity.badRequest().body((Object)new MessageResponse("Error: Username is already taken!"));
        }
        if (this.userRepository.existsByEmail(signUpRequest.getEmail()).booleanValue()) {
            return ResponseEntity.badRequest().body((Object)new MessageResponse("Error: Email is already in use!"));
        }
        User user = new User(signUpRequest.getUsername(), signUpRequest.getEmail(), this.encoder.encode((CharSequence)signUpRequest.getPassword()));
        Set strRoles = signUpRequest.getRole();
        HashSet<Role> roles = new HashSet<Role>();
        if (strRoles == null) {
            Role userRole = (Role)this.roleRepository.findByName(ERole.ROLE_USER).orElseThrow(() -> new RuntimeException("Error: Role is not found."));
            roles.add(userRole);
        } else {
            strRoles.forEach(role -> {
                switch (role) {
                    case "admin": {
                        Role adminRole = (Role)this.roleRepository.findByName(ERole.ROLE_ADMIN).orElseThrow(() -> new RuntimeException("Error: Role is not found."));
                        roles.add(adminRole);
                        break;
                    }
                    case "mod": {
                        Role modRole = (Role)this.roleRepository.findByName(ERole.ROLE_MODERATOR).orElseThrow(() -> new RuntimeException("Error: Role is not found."));
                        roles.add(modRole);
                        break;
                    }
                    default: {
                        Role userRole = (Role)this.roleRepository.findByName(ERole.ROLE_USER).orElseThrow(() -> new RuntimeException("Error: Role is not found."));
                        roles.add(userRole);
                    }
                }
            });
        }
        user.setRoles(roles);
        this.userRepository.save((Object)user);
        return ResponseEntity.ok((Object)new MessageResponse("User registered successfully!"));
    }

    @PostMapping(value={"/signout"})
    public ResponseEntity<?> logoutUser() {
        ResponseCookie cookie = this.jwtUtils.getCleanJwtCookie();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Set-Cookie", new String[]{cookie.toString()})).body((Object)new MessageResponse("You've been signed out!"));
    }
}

