/*
 * Decompiled with CFR 0.152.
 */
package com.bezkoder.spring.login.controllers;

import com.bezkoder.spring.login.models.User;
import com.bezkoder.spring.login.repository.UserRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"}, maxAge=3600L)
@RestController
@RequestMapping(value={"/api/test"})
public class TestController {
    private final UserRepository userRepository;

    public TestController(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @GetMapping(value={"/miTest"})
    String miPrimera() {
        return "Servicio configurado correctamente";
    }

    @GetMapping(value={"/all"})
    public String allAccess() {
        List users = this.userRepository.findAll();
        String allUsernames = users.stream().map(User::getUsername).collect(Collectors.joining(","));
        return allUsernames;
    }

    @GetMapping(value={"/user"})
    @PreAuthorize(value="hasRole('USER') or hasRole('MODERATOR') or hasRole('ADMIN')")
    public String userAccess() {
        return "User Content.";
    }

    @GetMapping(value={"/mod"})
    @PreAuthorize(value="hasRole('MODERATOR')")
    public String moderatorAccess() {
        return "Moderator Board.";
    }

    @GetMapping(value={"/admin"})
    @PreAuthorize(value="hasRole('ADMIN')")
    public String adminAccess() {
        return "Admin Board.";
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public String hello() {
        return "hello world";
    }
}

